#include <amxmodx>
#include <amxmisc>
#include <engine>
#include <cstrike>
#include <fakemeta_util>
#include <zombieplague>
 
#define PLUGIN  "Zombie Mod [VIP]"
#define AUTHOR  "kzesc"
#define VERSION "1.1"
 
#define ADMINACCESS ADMIN_LEVEL_H
 
static const COLOR[] = "^x04" //green
//static const CONTACT[] = "zombieplague.de"
const g_armor_amount = 0
new const g_sound_buyarmor[] = { "items/tr_kevlar.wav" }
//new const g_model[] = { "models/player/vip/vip.mdl" }
new bool:dojump[33] = false
new jumpnum[33] = 0
new gmsgSayText
new ammo
new maxplayers
new health
new add_health
new hp_max
new killer_hp
new infect_ammo
 
new const VIP_STATUS[] = "VIP ONLINE"
new const VIP_STATUS_N[] = "No VIP online"
new const CONTACT_ADMIN[] = "Contact the Server Admin"
 
 
public plugin_init()
{
        register_plugin(PLUGIN, VERSION, AUTHOR)
        register_event("DeathMsg", "death_msg", "a")
        register_logevent("logevent_Round_Start", 2, "1=Round_Start")
        register_clcmd("say", "handle_say")
        register_clcmd("say /wantvip", "ShowMotd")
        register_clcmd("say /vip", "ShowMotd")
        
        register_cvar("amx_contactinfo", "kzesc www.server-fun.at.ua")
        register_cvar("vip_multijump", "3")
        ammo = register_cvar("vip_kill_ammo", "4")
        health = register_cvar("vip_hp_on_infect", "300")
        infect_ammo = register_cvar("vip_ammo_on_infect", "3")
        
        gmsgSayText = get_user_msgid("SayText")
        maxplayers = get_maxplayers()
}
 
public death_msg()
{
        if(read_data(1)<=maxplayers && read_data(1) && read_data(1)!=read_data(2))
                zp_set_user_ammo_packs(read_data(1), zp_get_user_ammo_packs(read_data(1)) + get_pcvar_num(ammo));
}
 
public client_putinserver(id)
{
	jumpnum[id] = 0;
	dojump[id] = false; 
}
 
public client_disconnect(id)
{
        jumpnum[id] = 0
        dojump[id] = false
}
 
public zp_user_infected_post(player, infector)
{
        add_health = get_pcvar_num(health)
        hp_max = zp_get_zombie_maxhealth(infector)
        if(!(get_user_flags(infector) & ADMINACCESS) && !is_user_alive(infector))
                return PLUGIN_CONTINUE;
        
        killer_hp = get_user_health(infector)
        killer_hp += add_health
        if (killer_hp > hp_max)
        {
                killer_hp = hp_max
                fm_set_user_health(infector, killer_hp)
        }
        
        zp_set_user_ammo_packs(infector, zp_get_user_ammo_packs(infector) + get_pcvar_num(infect_ammo))
        
        return PLUGIN_CONTINUE
}
 
public handle_say(id)
{
        new said[192]
        read_args(said, 192)
        if((containi(said, "who") != -1 && containi(said, "admin") != -1) || contain(said, "/vips") != -1)
                set_task(0.1, "print_adminlist", id);
        
        return PLUGIN_CONTINUE
}
 
public plugin_precache()
{
        precache_model("models/player/vip/vip.mdl")
        
        return PLUGIN_CONTINUE
}
 
public resetModel(id, level, cid)
{
        if (get_user_flags(id) & ADMIN_CVAR)
        {
                new CsTeams:userTeam = cs_get_user_team(id)
                if (userTeam == CS_TEAM_T)
                {
                        cs_set_user_model(id, "models/player/zombie_source/zombie_source.mdl")
                }
                else if(userTeam == CS_TEAM_CT)
                {
                        cs_set_user_model(id, "models/player/vip/vip.mdl")
                }
        }
        else
        {
                cs_reset_user_model(id)
        }
        
        return PLUGIN_CONTINUE
}
 
public logevent_Round_Start()
{
        for(new i=0; i<= maxplayers; i++)
        {
                if(get_user_flags(i) & ADMINACCESS)
                {
                        set_pev(i, pev_armorvalue, float(pev(i, pev_armorvalue)+g_armor_amount))
                        engfunc(EngFunc_EmitSound, i, CHAN_BODY, g_sound_buyarmor, 1.0, ATTN_NORM, 0, PITCH_NORM)
                }
        }
}
 
public print_adminlist(user) 
{
        new adminnames[33][32]
        new message[256]
        new contactinfo[256], contact[112]
        new id, count, x, len
        
        for(id = 1 ; id <= maxplayers ; id++)
                if(is_user_connected(id))
                        if(get_user_flags(id) & ADMINACCESS)
                                get_user_name(id, adminnames[count++], 31);
        
        len = format(message, 255, "%s %s: ", COLOR, VIP_STATUS)
        if(count > 0)
        {
                for(x = 0 ; x < count ; x++)
                {
                        len += format(message[len], 255-len, "%s%s ", adminnames[x], x < (count-1) ? ", ":"")
                        if(len > 96)
                        {
                                print_message(user, message)
                                len = format(message, 255, "%s ", COLOR)
                        }
                }
                print_message(user, message)
        }
        else
        {
                len += format(message[len], 255-len, "%s.", VIP_STATUS_N)
                print_message(user, message)
        }
        
        get_cvar_string("amx_contactinfo", contact, 63)
        if(contact[0])
        {
                format(contactinfo, 111, "%s %s -- %s", COLOR, CONTACT_ADMIN, contact)
                print_message(user, contactinfo)
        }
}
 
print_message(id, msg[])
{
        message_begin(MSG_ONE, gmsgSayText, { 0, 0, 0 }, id)
        write_byte(id)
        write_string(msg)
        message_end()
}
 
public client_PreThink(id)
{
        if(!is_user_alive(id))
                return PLUGIN_CONTINUE;
        
        if(!access(id, ADMINACCESS))
                return PLUGIN_CONTINUE;
        
        new nbut = get_user_button(id)
        new obut = get_user_oldbutton(id)
        
        if((nbut & IN_JUMP) && !(get_entity_flags(id) & FL_ONGROUND) && !(obut & IN_JUMP))
        {
                if(jumpnum[id] < get_cvar_num("vip_multijump"))
                {
                        dojump[id] = true
                        jumpnum[id]++
                        return PLUGIN_CONTINUE
                }
        }
        
        if((nbut & IN_JUMP) && (get_entity_flags(id) & FL_ONGROUND))
        {
                jumpnum[id] = 0
                return PLUGIN_CONTINUE
        }
        
        return PLUGIN_CONTINUE
}
 
public client_PostThink(id)
{
        if(!is_user_alive(id))
                return PLUGIN_CONTINUE;
        
        if(!access(id, ADMINACCESS))
                return PLUGIN_CONTINUE;
        
        if(dojump[id] == true)
        {
                new Float:velocity[3]
                entity_get_vector(id, EV_VEC_velocity, velocity)
                velocity[2] = random_float(265.0, 285.0)
                entity_set_vector(id, EV_VEC_velocity, velocity)
                dojump[id] = false
                return PLUGIN_CONTINUE
        }
        
        return PLUGIN_CONTINUE
}
 
public ShowMotd(id)
{
        show_motd(id, "vip.txt")
}
/* AMXX-Studio Notes - DO NOT MODIFY BELOW HERE
*{\\ rtf1\\ ansi\\ deff0{\\ fonttbl{\\ f0\\ fnil Tahoma;}}\n\\ viewkind4\\ uc1\\ pard\\ lang1031\\ f0\\ fs16 \n\\ par }
*/
